# This file contains code that manages lip flap.

init -100 python:

    def lip_flap_combine(prefix, part, suffix):
        return Image(prefix + part + suffix)
    
    class LipFlap(object):

        def __init__(self, prefix, default="", suffix=".png", combine=lip_flap_combine):
            self.prefix = prefix
            self.default = default
            self.suffix = suffix
            self.combine = combine

        def parameterize(self, name, parameters):

            if not parameters:
                return self.combine(self.prefix, self.default, self.suffix)

            if len(parameters) > 1:
                raise Exception("LipFlap can only be shown with 0 or 1 parameters.")

            param = eval(parameters[0])

            split = param.split()
            images = split[0::2]
            times = [ float(i) for i in split[1::2]]
            
            if len(times) < len(images):
                times.append(86400.0)

            args = [ ]

            for a, b in zip(images, times):
                args.append(self.combine(self.prefix, a, self.suffix))
                args.append(b)

            return Animation(anim_timebase=False, *args)
        
        def predict(self, callback):
            self.combine(self.prefix, self.default, self.suffix).predict(callback)
            
