﻿# You can place the script of your game in this file.

init:
    # Declare images below this line, using the image statement.
    image splash = "titlescreen.jpg"

    # Define characters used by this game.
    define y = Character('Ewe', color="#5b9e41")
    define a = Character('Anaya', color="#ff0033")
    define ss = Character('Secretary of State Haig', color="#3886bc")
    define c = Character('Submarine Captain', color="#d7a828")
    
    image bg ewe = "ewe.jpg"
    image bg standard = "bg_standard.jpg"
    image bg sheep = "bg_sheep.jpg"
    image bg graze = "bg_graze.jpg"
    image bg argcamp = "bg_argcamp.jpg"
    image bg meeting = "bg_meeting.jpg"
    image bg speed = "bg_speed.jpg"
    image bg submarine = "bg_submarine.jpg"
    image bg subint = "bg_submarineint.jpg"
    image bg belgrano = "bg_belgrano.jpg"
    image bg battle = "bg_battle.jpg"
    image bg ggreen = "bg_goosegreen.jpg"
    image bg mines = "bg_mines.jpg"
    image bg argies = "bg_argies.jpg"
        
    image y big = "ewe_big.png"
    image y med = "ewe_medium.png"
    image y meeting = "ewe_meeting.png"
    image y meetingl = "ewe_meetingl.png"
    image y horror = "ewe_horror.jpg"
    image y armed = "ewe_armed.png"
    image y unarmed = "ewe_unarmed.png"
    image y shower = "ewe_shower.png"
    image y bani = LipFlap("ewe_baa", "A", ".png")
    image y launch = "ewe_launch.png"
    image y subinspector = "inspectorA.png"
    image y subinspectorani = LipFlap("inspector", "A", ".png")
    image haig = "haig.png"
    image haig meeting = "haig_meetingA.png"
    image haig meetingani = LipFlap("haig_meeting", "A", ".png")
    image anaya meeting = "anaya_meetinganiA.png"
    image anaya meetingani = LipFlap("anaya_meetingani", "A", ".png")
    
    image xmark = "xmark.png"
    image blood = "blood.png"
    image belt = "belt.png"
    image explosion = "explosion.png"
    image sas = "sas.jpg"
    image teabag = "teabag.png"
    image buttons = "bg_subbuttons.jpg"
    image meattruck = "meattruck.png"

    $ flash = Fade(.25, 0, .75, color="#fff")
    $ flashfast = Fade(.05, 0, .05, color="#fff")
  
  

label splashscreen:
    $ renpy.pause(0)
    scene black 
    with Pause(0.5)
    
    show splash    
    with Pause(2.0)

    return
  
label start:
    scene black
    with fade
    
    "You are Ewe, a pacifist sheep living on the Falkland Islands in the 1980s."
    "Any day now, war is going to be waged between the Argentinians and the British over your grass."
    
    scene black
    with fade
    
    "{b}2 APRIL 1982{/b}"  
    

label firstchoice:    
    scene bg standard
    with fade    
    "Argentine forces mount an amphibious landing of the Falkland Islands. The war has begun."    
    "What do you do?"    
    
    menu:
        "This is a clear case of the Argentinian military junta trying to divert public attention from the country's chronic economic problems. Alert the other sheep!":
            jump alertsheep
    
        "Graze a bit and think about it.":
            jump graze          
    
label alertsheep:    
    scene bg sheep
    with fade   
    "You alert the other sheep"
    "They appear unconcerned. What do you do?"

    menu:
        "Initiate diplomatic relations with the occupying Argentinian forces":
             jump diprelations
    
        "Go back to grazing":
             jump graze
        
label graze:
    scene bg graze   
    with fade    
    "You graze"
    "The US tries to mediate and bring the conflict to an early end."
    "Here comes the US Secretary of State, Alexander Haig."
    "What do you do?"

    menu:
        "Talk to Secretary of State Haig and debrief him.":
             jump debrief
    
        "Go back to grazing.":
             jump graze2
    
             
             
             
    ######  ARGENTINIAN  ######             
             
             
label diprelations:    
    scene bg argcamp
    with fade
    "You wander into the Argentinian camp and ask to speak to the commanding officer."    
    "The soldiers stare at you, confused."
    "They are clearly in no mood for negotiation."
    "What do you do?"
    menu:
        "Try talking to the British instead.":
             jump british
    
        "Go back to grazing.":
             jump graze
    
label debrief:
    scene bg standard
    with fade   
    show haig
    with dissolve
    "You try and alert Secretary of State Haig to the current state of affairs."
    hide haig
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaa!"
    "Secretary of State ignores you and proceeds to the meeting with the Argentinian generals."
    "What do you do?"
    menu:
        "Attend the meeting":
             jump meeting
    
        "Go back to grazing.":
             jump graze2          

label meeting:
    scene bg meeting   
    with fade
    show haig meeting
    with dissolve
    show haig meetingani "A .15 B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A"
    voice "haig-long.ogg"     
    ss "Although we are normally very happy to sell arms to military dictatorships .."
    show haig meetingani "B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A"
    voice "haig-short.ogg" 
    ss "... in this case the US will be sell you NO MORE WEAPONS."
    "The Argentinians are mad."    
    "What do you do?"    
    menu:
        "In light of the inevitable war, revise your pascifist philosophy":
             jump revisephilosophy
    
        "Go back to grazing.":
             jump graze2          
            
label revisephilosophy:
    scene bg meeting    
    show y meeting:
        parallel:
            zoom 1.0            
            linear 7.0 zoom 1.2
        parallel:
            xpos 50 ypos 100 xanchor 0 yanchor 0
            linear 7.0 xpos -150 ypos -60

    "Suddenly, it dawns on you ... {p=2.5}There's going to be a war anyway...  {p=2.5}Regardless of the disputed sovereignty of the island, you need to make a decision ...  "        
    show xmark:
        zoom 1.2
        xpos 420 ypos 15 xanchor 0 yanchor 0
    "Who will protect your beautiful grasslands better?"       
    menu:
        "The Argentinians":
             jump teamargentina
    
        "The British":
              jump teambritain
              
        "Go back to grazing":
             jump graze2       
             
             
label teambritain:
    scene bg meeting  
    show y meetingl
    with dissolve
    "The British do have greater military strength ..."
    "Besides, they'll probably protect the islands for decades to come if the rumours of massive off-shore oil reserves are true."
    "Maybe siding with the British is the lesser of two evils."     
    menu:
        "Go talk to the British":
             jump british 
              
        "Go back to grazing":
             jump graze2          
         
label teamargentina:
    scene bg meeting       
    show y meetingl
    with dissolve
    "With patriotic tears welling in your dark, ovine eyes, you present yourself to the Argentinians for service."
    "The chief architect of the Falkland invasion, Admiral Jorge Anaya, looks down at you."
    hide y med
    show anaya meeting
    with dissolve
    voice "anaya-short.ogg" 
    show anaya meetingani "A .15 B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .20 A .10 B .15 A .05 B .30 A"
    a "If we can't have US weapons, we will use sheep instead!"
    "You have no idea what Admiral Anaya said."
    "What do you do?"
    $ ta1 = False
    $ ta2 = False
    $ ta3 = False
    menu:
        "Present your plan for sustained military victory over the islands":
            $ ta1 = True
            jump suicidesheep
    
        "Compliment the general on his shiny buttons":
            $ ta2 = True
            jump suicidesheep
              
        "Go back to grazing":
            $ ta3 = True
            jump suicidesheep        
             
label suicidesheep:
    scene bg meeting    
    show y bani
    with dissolve
    if ta1:
        "You outline your military strategy in detail to the Admiral"
    if ta2:
        "You compliment the Admiral on his shiny buttons"
    if ta3:
        "You go to leave and return to your lush grasslands, but the Admiral's henchmen block your path. You are trapped!"
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaaa!"
    hide y bani
    show anaya meeting
    with dissolve     
    show anaya meetingani "A .15 B .50 A 1.10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .30 A"
    voice "anaya-long.ogg"    
    a "Men! {p=1.0}Equip this sheep with explosives and exocet missiles; she will be our SECRET WEAPON!"
    "One of the Argentinian soldiers discreetly points out that the US Secretary of State is still present"  
    show anaya meetingani "A .15 B .10 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .20 A 1.10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A"
    voice "anaya-long.ogg"
    a "Then we have to KILL Secretary of State Haig! {p=1.0}It will be the ewe's first mission"                                                                                                                               
    "What do you do?"
    scene black

    menu:
        "Kill Secretary of State Haig":
             jump killhaig 
              
        "Turn on your new Argentinian overlords instead":
             jump killoverlords                       
          

label killhaig:    
    play music "amb-kill.ogg" fadein 1 fadeout 1
    scene black
    with dissolve
    scene bg speed:
        block:            
                xpos 0 ypos 0
                linear 30 xpos -700 ypos 0
        time 30
                
    show y launch:
        alpha 0        
        xpos -450 ypos 0
        linear 1.0 alpha 1.0          
    with fade
    "With the fury of a trillion shrews, you leap at Secretary of State Haig's bare throat."
    show y launch:
        xpos -400 ypos 0        
    with dissolve
    "Gnashing and tearing and biting, you rip out Secretary of State Haig's jugular and swallow it"
    show y launch:
        xpos -350 ypos 0        
    with dissolve
    "Secretary of State Haig's freshly extracted jugular vein ends up in your rumen ..."
    show y launch:
        xpos -300 ypos 0        
    with dissolve
    "From there, it moves gradually into your reticulum where it is broken down by bacteria and acid to form cud ..."
    show y launch:
        xpos -250 ypos 0        
    with dissolve
    "Muscles in your reticulum then push the cud into your mouth for a good second chewing  ..."
    show y launch:
        xpos -200 ypos 0        
    with dissolve
    "Secretary of State stares at you in horror"
    show y launch:
        xpos -150 ypos 0        
    with dissolve
    ss "... aaah ... "
    show y launch:
        xpos -100 ypos 0        
    with dissolve
    "You then swallow the cud down into the third of your four stomachs, the omasum, for a little more digestion ..."
    show y launch:
        xpos -50 ypos 0        
    with dissolve
    "Finally, it makes its way to the abomasums - where it is mixed with acids ..."
    show y launch:
        xpos 0 ypos 0        
    with dissolve
    " - before finally entering the intestine. "
    stop music
    play sound "scream.ogg"
    show y horror:
        parallel:
            zoom 1.0                         
            linear 0.1 zoom 1.5        
            linear 0.15 zoom 1.0      
            repeat 3
        parallel:
            xpos 0 ypos 0 
            linear 0.1 xpos -200 ypos -150     
            linear 0.15 xpos 0 ypos 0     
            repeat 3
        
    show blood:
        alpha 0.8
        xpos 0 ypos -700 xanchor 0 yanchor 0
        linear 2.0 xpos 0 ypos 0
        linear 1.0 alpha 0.0    
    
    $ renpy.pause(4)
    ss "... araaaagghh ...  "    
    hide blood
    hide bg speed with dissolve
    hide y horror with dissolve    
    "You look upon Secretary of State Haig with the disinterested, unconcerned gaze of a psycopath as he dies an agonising and horrifyingly bloody, herbivore death. "
    "The Admiral is pleased with you and rewards you with a lovely belt"
    show belt
    with fade
    "The belt has dynamite strapped to it"
    "Your fate is sealed {p=1}Your next mission is at the battle of Goose Green ..."
    jump goosegreenargie
 
label goosegreenargie:    
    scene black    
    with fade
    "{b}=== Battle of Goose Green ===={/b}"
    with fade
    scene bg standard
    with dissolve        
    show y unarmed
    with dissolve
    menu:
        "Charge the British, firing all your missiles and detonating your bomb belt.":
             jump detonate
    
        "Actually, maybe now is a good time to go back to grazing.":
             jump grazebattle             

label killoverlords:
    scene black
    scene bg meeting
    play music "amb-kill.ogg" fadein 1 fadeout 1
    show y meeting
    "Killing is strictly against your nature and instincts. You can't do it."
    "But then Secretary of State Haig makes you an offer you can't refuse:"
    show haig meetingani "A .15 B .20 A .10 B .15 A .05 B .30 A .15 B .20 A .10 B .15 A .05 B .30 A"
    voice "haig-short.ogg"
    ss "I'll make you king of Peru"
    "You've always wanted to be king of Peru. Bet you didn't know that. Now you do."
    scene bg speed:
        block:            
                xpos 0 ypos 0
                linear 10 xpos -700 ypos 0
        time 10
                
    show y launch:
        alpha 0        
        xpos -450 ypos 0
        linear 1.0 alpha 1.0          
    with fade
    "With the rage of a hundred gazelles, you round on Admiral Anaya and vomit up your acidic cud onto his face."
    show y launch:
        alpha 0        
        xpos -250 ypos 0
        linear 1.0 alpha 1.0  
    "Temporarily blinded, Admiral Anaya stumbles head-first into the bullet that Secretary of State Haig has just fired at him"
    show y launch:
        alpha 0        
        xpos -50 ypos 0
        linear 1.0 alpha 1.0  
    "Your servillitude to the Argentinian forces has come to an end"
    stop music
    play sound "scream.ogg"
    show y horror:
        parallel:
            zoom 1.0                         
            linear 0.1 zoom 1.5        
            linear 0.15 zoom 1.0      
            repeat 3
        parallel:
            xpos 0 ypos 0 
            linear 0.1 xpos -200 ypos -150     
            linear 0.15 xpos 0 ypos 0     
            repeat 3
        
    show blood:
        alpha 0.8
        xpos 0 ypos -700 xanchor 0 yanchor 0
        linear 2.0 xpos 0 ypos 0
        linear 1.0 alpha 0.0    
    
    $ renpy.pause(4)
    hide blood
    hide bg speed with dissolve
    hide y horror with dissolve
    hide bg meeting
    a "... araaaagghh ...  "          
    "You are KING OF PERU!"
    "Congratualtions! If this game can be won, this is possibly the most winningest win there is."
    "Enjoy your new empire."
    with fade
    play sound "fanfare.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return

        
label detonate:
    scene bg standard
    show y unarmed
    with dissolve
    y "By the power of Falklands! Give me strength, beyond strength!"
    show y armed
    with flash
    show y armed:
        parallel:
            zoom 1.0
            linear 8 zoom 2
        parallel:
            xpos 400 ypos 600 
            linear 8 xpos 400 ypos 800
               
    "You run towards the British SAS soldiers, bearing your teeth and shouting"
    y "GRASS IS GOOD! GRASS IS GOOD!"
    "As you draw near, you arm and fire your exocet missiles"
    "The missiles fly off in all directions"
    "You prime, then detonate your suicide belt"
    play sound "explosion.ogg"
    show explosion
    with flashfast
    show explosion
    with flashfast
    "You explode in a shower of wool."
    hide y armed
    hide explosion    
    with dissolve
    show y shower:
        zoom 1.0
        alpha 1
        xpos 0 ypos -900 
        linear 7.0 xpos 0 ypos 700
        linear 7.0 alpha 0.0  
    $ renpy.pause(3)
    "Wool and blood"
    "You were a good 2 and a half miles away from the soldiers"
    hide y shower
    "And you are dead"
    "Gloriously, heroicly dead"
    scene black
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"    
    with fade
    return
  
label grazebattle:
    scene bg graze    
    with fade
    "You return to grazing."
    "Man, this is good grass"
    "You forgot just how good grazing is"
    y "Baaaaaaaa!"
    "Maybe in a bit, you'll stand still and chew your cud"
    play sound "explosion.ogg"
    show explosion:
        xpos 150 ypos -70
    with flashfast
    show explosion
    with flashfast
    "Suddenly, out of no where, a rocket-propelled grenade hits you square in the flank"
    show sas
    with flash 
    "The SAS have snuck up on you!"
    hide bg graze
    hide explosion    
    "You explode in a shower of wool."
    hide sas
    with dissolve
    scene bg standard
    show y shower:
        zoom 1.0
        alpha 1
        xpos 0 ypos -900 
        linear 7.0 xpos 0 ypos 700
        linear 7.0 alpha 0.0  
    $ renpy.pause(3)
   
    "Wool and blood"
    "And you are dead"
    "Such is the life of a sheep"
    scene black
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return    
    
    
    
    ######  BRITISH ######

label british:    
    scene bg standard    
    with fade
    show y unarmed:
        zoom 0.75
        xpos 400 ypos 150
        linear 7 xpos -400 ypos 150
    with dissolve
    
    "You leave the Argentinian camp, in search of the British"
    scene bg submarine
    with dissolve
    "You find them in a submarine"
    "But how do you get onto the submarine?"
    
    menu:
        "Disguise yourself as a submarine inspector":
             jump submarineinspector
    
        "Disguise yourself as a teabag":
             jump teabag
        
    
label submarineinspector:    
    scene bg standard
    show y subinspector
    with dissolve
    "You flag down the HMS Conqueror"
    "The Royal British Navy see that you are a submarine inspector and, since they are in a submarine, they pull over to pick you up"
    y "Good day, ol' chaps, Oi be here to inspect yer exquisite submarine"
    "Is what you mean to say. Instead, you say,"
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaaaa!"
    "Your cover is blown!"    
    "The British know now that you are Argentinian spy scum and they spontaneously open fire, killing you to tiny pieces."
    play sound "gunfire.ogg"
    scene black
    with fade    
    "Then they feed those pieces to the penguins."
    "To add insult to injury, the penguins spit your pieces back out."    
    "Not even the penguins like you."
    "You are dead. And you taste disgusting."
    scene black
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return   
    
label teabag:    
    scene bg standard
    show teabag
    with dissolve
    "Clever girl! Of course, the British can't resist a good cuppa"
    "The submarine crew spot the \"teabag\" with their periscope and dispatch an urgent dinghy to pick you up."
    scene bg subint
    with fade
    "Back on the submarine, the captain makes a cup of tea with you and then leaves the room while you soak."
    "What do you do?"
    
    menu:
        "Jump out of the cup":
             jump outofcup
    
        "Go back to grazing":
             jump grazeno    
    
             
label grazeno:    
    scene bg subint
    "It's way too late for that. You are a sheep, disguised as a tea bag, on the HMS Conqueror, a nuclear submarine 100ft beneath the ocean. And you want to go back to grazing?? Sorry."
    jump outofcup


label outofcup:    
    scene bg subint    
    "You jump out of the cup and dry yourself off."
    "You are in the control room of the submarine."
    show buttons
    with dissolve
    "You see three buttons. Which one do you press?"
    menu:
        "That one":
             jump thatone
    
        "No, that one":
             jump thatone
             
        "No, no! Hang on. Wait. That one":
             jump thatone
             
label thatone:    
    scene black
    show buttons
    "You press the button ... "
    hide buttons
    with fade
    "... you hear the hiss of a missile firing..."
    show bg belgrano
    with flash
    play sound "explosion.ogg"
    show explosion:
        xpos 150 ypos -70
    with flashfast
    show explosion:
        xpos 100 ypos 70
    with flash
    hide explosion
    with dissolve
    "Oh noes! You sunk the Belgrano!"
    "Bad sheep!"
    "You just killed 323 people and escalated the war."    
    "What were you doing pressing random buttons in a nuclear submarine anyway?"
    hide bg belgrano
    with fade
    "And now the captain's coming. What do you do?"
    menu:       
        "Own up and admit what you did":
             jump captainrage
             
        "Just act dumb. Maybe he won't suspect you.":
             jump captainrage2

   
label captainrage:    
    scene bg subint
    "The captain storms in"
    show y subinspector
    with dissolve
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short2.ogg"
    c "WHO FIRED THE MISSILE!?!"    
    "You step forward and fearlessly announce to the captain what you did and that you do not apologise for your actions."
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaaa!"
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short2.ogg"
    c "YOU FIRED THE MISSILE?!"
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaaa!"    
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short3.ogg"    
    c "BLOODY GOOD JOB!!"
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .10 A 0.5 B .05 A .10 B .05 A .05 B .05 A .10  B .10 A"
    voice "subcapt-short.ogg"
    c "YOU GOT THE BASTARDS! {p=0.5} YOU WILL BE OUR NEW MASCOT!"   
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "baa.ogg"
    y "Baaaaaa!"    
    jump goose
label captainrage2:    
    scene bg subint
    "The captain storms in"
    show y subinspectorani
    with dissolve
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short2.ogg"   
    c "WHO FIRED THE MISSILE!?!"
    "The captain looks at you."    
    "You stand still, blankly staring back at him."
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short2.ogg"   
    c "WHOSE SHEEP IS THIS !?!"
    "You say nothing. You just stare back."
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short2.ogg"   
    c "WHAT IS A SHEEP DOING HERE !?!"    
    "You try and blend in. You say nothing."
    show y subinspectorani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A "
    voice "subcapt-short3.ogg"   
    c "WHO WANTS LAMB TONIGHT !?!"
    "And with that, the captain lops off your head with his Swiss Army Knife"
    scene black
    with fade
    "That evening, the entire crew of the HMS Endeavour feast like kings on your corpse. "
    "They then went on to win the war. So, in a sense, you helped."
    "But in another sense, you just got eaten."    
    scene black
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return   
        
label goose:        
    scene black
    "{b}=== BATTLE OF GOOSE GREEN ==={/b}"
    scene bg ggreen
    with fade   
    "It's the most important battle of the Falklands conflict: "
    "The battle of Goose Green."
    show y unarmed:
        xpos 0 ypos 100
    with dissolve
    "The British need your help."
    "What do you do?"    
    menu:       
        "Shout insulting slogans at the Argentinians, calling Eva Peron's reputation into question":
             jump evita
             
        "Grab an M16 off the nearest SAS commando and 'go it alone'.":
             jump goitalone

             
label evita:    
    scene bg argies
    with fade
    show y bani:
        xpos 350 ypos 0 
        linear 5 xpos 50 ypos 0
    "You walk up to within shouting distance of the Argentinian army and yell:"
    "\"Eva Peron was a witch who used the lungs of poor children as cushioned insoles for her many fancy shoes.\""
    "\"And the musical was NOTHING TO WRITE HOME ABOUT\""
    show y bani "A .05 B .05 A .10 B .05 A .05 B .10 A .05 B .05 A .10 B .05 A .05 B .10 A ":
        xpos 50 ypos 0
    voice "baa.ogg"
    y "Baaaaaaa!"
    hide y bani
    with dissolve     
    show bg argies:
        parallel:
            zoom 1.0
            linear 8 zoom 1.8
        parallel:
            xpos 400 ypos 600
            linear 10 xpos 300 ypos 1050
    "A worried look breaks out on the face of one of the Argentinian soldiers"     
    "Worry turns into fear."
    "Fear turns into widespread chaos and panic."
    "The Argentinians are laying down their weapons!"
    "And are turning and running away."
    play sound "crying.ogg"
    "And crying like little girl-babies!"
    show bg ggreen:
        zoom 1.0
        xpos 400 ypos 600
    with fade
    "You have just, single-handedly won the Falkland War!"
    jump conclusion
    
label goitalone:
    scene bg battle
    with fade
    show y unarmed:
        xpos 0 ypos 50
    with dissolve
    "You grab the nearest assault rifle and a strap-on rocket launcher ..."    
    show y armed:    
    with flash
    show y armed:
        parallel:
            zoom 1.0
            linear 8 zoom 2
        parallel:
            xpos 0 ypos 50 
            linear 8 xpos -100 ypos -300
               
    "... And you charge over the hill towards the Argentinian army."   
    voice "baa.ogg"
    y "BAAAAAAAAAAAAAAAA!!"
    "You don't get close to them. In fact, you don't even fire a single shot. You're a sheep. You find it hard to hold a rifle, let alone pull the trigger."
    "Instead, you are shredded to tiny bits in a hail of gunfire and exocet missiles"
    play sound "explosion.ogg"
    show explosion
    with flashfast
    show explosion
    with flashfast
    "You explode in a shower of wool."
    hide y armed
    hide explosion    
    with dissolve
    show y shower:
        zoom 1.0
        alpha 1
        xpos 0 ypos -900 
        linear 7.0 xpos 0 ypos 700
        linear 7.0 alpha 0.0  
    $ renpy.pause(3)
    "Wool and blood."    
    scene black
    with fade
    "You are dead. But you are also a hero."
    "A really stupid hero."
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return   
    
  
label conclusion:
    scene bg mines
    with fade
    "So the war is over."
    "But there are still 117 uncleared minefields on the Falkland Islands."
    "Not to mention unexploded ordinance scattered all over the place."
    "What do you want to do?"
    menu:       
        "Go for a walk":
             jump walk
             
        "I'm fine thanks; I'll just stay put.":
             jump stayput
    
label stayput:
    scene bg mines
    "Are you sure? Your feet are starting to get sore from staying in one place for so long."
    "What do you want to do?"
    menu:       
        "Alright, go for a walk":
             jump walk
             
        "Try placing your weight on your other foot to ease the pressure.":
             jump easepressure             

label easepressure:
    scene bg mines
    "Hmmm, that hasn't really worked. Your feet are still really sore."
    "And look! Something soooo cool is over there."
    
    menu:     
        "Ignore the pain in your feet; it'll go away.": 
            jump ignorepain
        "Take a walk and see what the fuss is over there":
            jump walk

label ignorepain:
    scene bg mines
    "Maybe you should see a doctor, because, like, your feet really REALLY hurt. This isn't normal. "
    "The doctor is just over there."    
    menu:           
        "Alright, go and see the doctor.":
            jump walk                      
            
label walk:
    scene bg standard
    show y unarmed:
        xpos 250
        ypos 50
    with dissolve
    "You walk ... "
    show y unarmed:
        linear 2 xpos 150 ypos 50
    "Careful of the mines, now ..."
    show y unarmed:
        linear 2 xpos -50 ypos 50
    $ renpy.pause(2)
    play sound "explosion.ogg"
    show explosion
    with flashfast
    show explosion
    with flashfast
    hide explosion
    with dissolve
    show y unarmed:
        parallel:
            zoom 1.0
            linear 2 zoom 0.2
        parallel:
            xpos -200 ypos -100
            linear 2 xpos 500 ypos -300
        parallel:
            linear 2 rotate 360
            repeat
    play sound "baa-mine.ogg"
    "Oh SHIIIIIIIIIIIIiiiiiiiiiiiiiii  - ..."
    scene black
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return 
    
    
label graze2:
    scene bg graze   
    with fade
    "You go back to grazing."
    "Yum, this grass tastes gooood"
    menu:       
        "Carry on grazing":
             jump graze3
             
        "Maybe you should talk to the Argentinian army":
             jump diprelations         
             
label graze3:
    scene bg graze   
    with fade
    "You graze some more."
    "Grazing is THE SHIT"
    menu:       
        "Carry on grazing":
             jump graze4
             
        "It's not too late, you could reach a peace deal by morning":
             jump diprelations           
             
label graze4:
    scene bg graze   
    with fade
    "You graze some more."
    "Never tasted grass this good. Mmm mmm."
    menu:       
        "Carry on grazing":
             jump graze5
             
        "Look, the Argentinian army are over there, go have a quiet word":
             jump diprelations       

label graze5:
    scene bg graze   
    with fade
    "You graze some more."
    "Damn, you love that cud."
    menu:               
        "Is that a helicopter? You should really try and seek a diplomatic resolution to all this.":
             jump diprelations                   
             
        "No, I'm fine just grazing, thanks":
             jump graze6                  
       
             
label graze6:
    scene bg graze   
    with fade
    "You graze some more."
    "{b}THE WAR IS OVER!{/b}"
    scene bg standard 
    with fade
    show y unarmed:
        zoom 0.5
        xpos 500 ypos 300
    play sound "truck-reverse.ogg"
    show meattruck:
        xpos -700 ypos 100
        linear 3 xpos -100 ypos 100
    $ renpy.pause(3)
    show y unarmed:
        parallel:
            linear 1 xpos 350 ypos 180
    $ renpy.pause(1.5)
    hide y unarmed
    with dissolve
    play sound "truck-forwards.ogg"
    show meattruck:
        linear 3 xpos -900 ypos 100
    $ renpy.pause(3)
    "Then you get sold for meat."
    scene black
    with fade
    "You are dead. But tasty."
    with fade
    play sound "dead.ogg"
    "{b}=== GAME OVER ==={/b}"
    with fade
    return 
    

