﻿# You can place the script of your game in this file.

init:
    $ renpy.music.set_music(1, True)
    
    # Declare images below this line, using the image statement.
    image splash = "titlescreen.jpg"
    image train = "train.png"
    image hand = "hand5.png"
    image matchbox = "matchbox.png"
    image picture = "picture.png"
    image book = "book.png"
    image water 1 = "water1.png"
    image water 2 = "water2.png"
    image note = "note.png"
    image abandonhope = "abandonhope.png"
    image blob = "blob.png"
    image blobb = "blob.png"
    image blobbb = "blob.png"
    image bg hallway = "hallway.jpg"
    
    # Shower effect
    image water ani:
        "water1.png"
        pause .05
        "water2.png"
        pause .05
        "water3.png"
        pause .05
        repeat

    # Define effects
    define slowdissolve = Dissolve(2.0)
    define fastfade = Fade(.3, 0, 0, color="#000")
    define slowfade = Fade(2, 0, 1, color="#000")
    $ flash = Fade(.25, 0, .75, color="#fff")
    $ flashfast = Fade(.02, 0, .02, color="#fff")
    $ dissolvefast = Dissolve(.05)
    
    # Define characters used by this game.
    define y = Character('You', color="#5b9e41")
    define w = Character('Woman', color="#d7a828")
    define v = Character('Visitor', color="#3886bc")
    define b = Character('Beatrice', color="#999999")

init python:
    #first we define our sets of pictures, music etc.
    for i in range(6):            
        renpy.image('nurse n%d' % i, 'nurse%d.png' % i) 
    for i in range(6):            
        renpy.image('visitor n%d' % i, 'visitor%d.png' % i) 
    for i in range(6):            
        renpy.image('poop n%d' % i, 'poop%d.png' % i) 
    for i in range(6):            
        renpy.image('hand n%d' % i, 'hand%d.png' % i) 
    for i in range(6):            
        renpy.image('rmate n%d' % i, 'roommate%d.png' % i) 
    for i in range(6):            
        renpy.image('bg common%d' % i, 'commonroom%d.jpg' % i)     
    for i in range(6):            
        renpy.image('bg canteen%d' % i, 'canteen%d.jpg' % i)
    for i in range(6):            
        renpy.image('bg grounds%d' % i, 'grounds%d.jpg' % i) 
    for i in range(6):            
        renpy.image('bg room%d' % i, 'room%d.jpg' % i) 
    for i in range(6):            
        renpy.image('bg shower%d' % i, 'shower%d.jpg' % i) 
    for i in range(6):            
        renpy.image('bg smoking%d' % i, 'smoking%d.jpg' % i) 
    
label splashscreen:
    $ renpy.pause(0)
    scene black 
    with Pause(0.5)    
    show splash with fade    
    with Pause(1)   
    return    

################   START GAME ###################
    
label start:    
    # A few variables need setting early on; these variables persist even after being sedated and restarting - that's why this reset is only called once upon first game start
    $ poop = True       
    $ pictureseen = False  
    $ bookseen = False  
    $ noteseen = False    
    $ mad = 1
    jump start2

label start2:    
    # Stop the music!
    $ renpy.music.stop(channel=1)
    $ renpy.music.stop(channel=7)
    
    # These variables need resetting every game
    $ visitorbeen = False 
    $ withvisitor = False
    $ train = False
    
    scene bg common5
    with fade    
    pause 1
    scene black with fastfade
    scene bg common4
    with fade
    pause 1
    scene black with fastfade
    scene bg common1
    with fade
    pause 1
    show nurse n2
    with slowdissolve
    $ w ("There you are!", interact=False)
    call mad_commonroom   
    pause 1.5
    w "Better now?"
    with dissolve  
    
label sc1a:              
    menu:
        "{b}\"Thank you\"{/b}":             
            show nurse n3
            with dissolvefast
            hide nurse n3
            $ mad -= 1
            jump sc1c    
        "{i}Better than what?{/i}":
           $ mad += 1
           call mad_commonroom
           show nurse n3
           with slowdissolve           
           "There is an uncomfortable pause"            
           w "Come on now"           
           menu:
               "{b}\"Go away\"{/b}":
                   $ mad += 1
                   call mad_commonroom
                   call mad_nurse
                   w "Come on now, be reasonable."
                   menu:
                       "{b}\"Fuck you!\"{/b}":
                           $mad += 1
                           call mad_commonroom
                           call mad_nurse
                           w "I'm warning you ..."                           
                           menu:
                               "{b}\"No, fuck you! Every day the same! Order. Warning. Punishment.\"{/b}":
                                   call dead
                                   jump start2
                               "Say nothing.":
                                   $mad -=1
                                   call hide_nurse
                                   jump sc1d
                       "{b}\"Please ... go away\"{/b}":
                           $mad -= 1                           
                           call hide_nurse
                           jump sc1d
               "{i}Go away{/i}":
                   $ mad +=1
                   jump sc1c          

label sc1b:
    call mad_commonroom
    pause .5
    y "Thank fuck ..."
    y "Did I just talk to myself?"
    y "I {i}am{/i} talking to myself"
    menu:
        "{i}That's the first sign of madness{/i}":
            "You could probably go for a walk"
            $ mad -=1                        
            jump sc3a
        "{b}\"SHUT UP!\"{/b}":
            $ mad += 1
            jump sc1d

label sc1c:
    call mad_commonroom
    call mad_nurse
    with dissolve
    pause .5
    "The woman is still here ..."
    w "You have a visitor"
    menu:
       "{b}\"Go away\"{/b}":
           $ mad += 1
           call hide_nurse
           jump sc1d
       "{b}\"OK\"{/b}":
           $ mad -=1           
           call hide_nurse
           jump sc2c
       "{i}Like a zoo{/i}":
            $ mad += 1
            call mad_commonroom
            call mad_nurse
            with dissolve
            w "Well?"
            menu:
                "{b}\"OK\"{/b}":
                    $ mad -= 1                    
                    call hide_nurse
                    jump sc2c
                "{b}\"I'm going for a walk\"{/b}":
                    $mad += 1                    
                    call hide_nurse
                    jump sc3a
                "{b}\"Go away\"{/b}":
                   $ mad += 1
                   call hide_nurse
                   jump sc1d

label sc1d:
    call mad_commonroom
    with dissolve
    pause .5
    "Alone again. {w=1} Maybe you should get some fresh air."
    menu: 
        "{i}Isn't that a euphamism for something?{/i}":            
            "You are really bored. {w=1} It's stressful."
            $ mad += 1
            call mad_commonroom
            with dissolve            
            pause .5
            menu:
                "Find something to eat":     
                    $ mad -= 1
                    jump sc2a
                "Take a shower":
                    $ mad -= 1
                    jump sc5a
                "Go to your room":
                    $ mad += 1
                    jump sc4a
        "{i}A walk. I'll go for a walk{/i}":
            $mad -=1
            jump sc3a          

    
### CANTEEN ###

label sc2a:    
    call mad_canteen
    with dissolve
    pause .5
    "The food here is shit"
    y "I'm not even hungry"
    menu:
        "{i}I should probably eat anyway{/i}":
            $mad -= 1
            jump sc2b
        "{i}I think the food is drugged{/i}":
            $mad += 1
            jump sc2b
        "{i}Wait, that picture ...  {/i}":            
            while mad > 1:    
                "You can't focus"
                menu:
                    "{i}Get a grip!{/i}":
                        $ mad -= 1
                        call mad_canteen
                        with dissolve                                        
                    "{i}Don't care ...{/i}":
                        $ mad +=1
                        if mad == 6:
                            call dead
                            jump start2
                        call mad_canteen
                        with dissolve                        
            y "My mum has that picture"
            menu:
                "Take a closer look":
                    jump sc2d                         
                "{i}What's it doing here?{/i}":
                    $mad += 1
                    call mad_canteen
                    with dissolve
                    menu:
                        "{i}She must've put it there{/i}":
                            $mad +=1
                            call mad_canteen
                            with dissolve
                            jump sc2b
                        "Examine it closely.":                                                        
                            jump sc2d      
                            
label sc2b:
    call mad_canteen
    call mad_nurse
    with dissolve
    "Suddenly, the woman is back again"
    w "Your visitor. {w=1}He's waiting"
    menu:
        "{b}\"So what?\"{/b}":
            $ mad += 1
            call mad_canteen
            call mad_nurse
            with dissolve
            w "Come now ..."
            menu:
                "{b}\"I know\"{/b}":
                    $ mad -= 1
                    hide nurse
                    with slowdissolve
                    jump sc2c
                "{b}\"Go away\"{/b}":
                    $ mad += 1
                    call mad_canteen
                    hide nurse                    
                    with slowdissolve
                    "You've lost your appetite anyway"
                    menu:
                        "Take a shower instead":
                            jump sc5a
        "{b}\"For what?\"{/b}":
            $ mad -= 1
            call mad_canteen
            call mad_nurse
            with dissolve
            w "For you {w=1}- Here he is ..."
            hide nurse
            with slowdissolve
            jump sc2c   
            
label sc2c:
    $ visitorbeen = True
    call mad_canteen    
    call mad_visitor
    with dissolve
    pause .5
    v "Good to see you!"
    show visitor n4
    with flashfast
    hide visitor n4
    call mad_visitor
    v "How are you keeping?"
    menu:
        "{i}Why is he checking up?{/i}":
            $ mad += 1
            call mad_canteen
            call mad_visitor
            "You look at him with a pained expression."
            "You want to give a dozen answers."
            "But you just can't order your thoughts."
            v "Should I go?"
            menu:     
                "{b}\"I have to take a shower, so ...\"{/b}":
                    $ mad += 1
                    call mad_canteen
                    call mad_visitor
                    with dissolve
                    v "OK, look, take care ..."
                    call hide_visitor
                    with slowdissolve
                    "You leave and go to the bathroom"
                    scene black 
                    with fade                    
                    jump sc5a
                "{b}\"No\"{/b}":
                    $ mad -= 1
                    call mad_canteen
                    call mad_visitor
                    with dissolve
                    y "I just want to clear the air ..."
                    v "What do you mean?"
                    menu:
                        "{i}What{/i} do {i}I mean?{/i}":
                            "You can't answer that question."
                            "And now you can't think of anything to say."
                            "Suddenly you don't understand what either of you are doing here."
                            $ mad += 1
                            call mad_canteen
                            call mad_visitor
                            with dissolve
                            y "I've got to go for a walk"
                            v "Should I come?"
                            menu: 
                                "{b}\"No\"{/b}":
                                    $ mad += 1
                                    call mad_visitor  
                                    with dissolve
                                    call hide_visitor
                                    with dissolve
                                    scene black
                                    with fade                                    
                                    jump sc3a
                                "{b}\"Sure\"{/b}":
                                    $ mad -= 1
                                    call mad_visitor
                                    with dissolve
                                    call hide_visitor
                                    with dissolve
                                    scene black
                                    with fade                                    
                                    jump sc3d
                        "{b}\"Actually, sorry can you {w=.5}come back another time?\"{/b}":
                            $ mad += 1
                            call mad_canteen
                            call mad_visitor
                            with dissolve
                            v "Sure! Sure! Well {w=.5}I mean, is there ... ?"
                            menu:
                                "{b}\"Please go\"{/b}":
                                    $ mad += 1
                                    call hide_visitor
                                    with slowdissolve
                                    scene black
                                    with fade                                    
                                    jump sc4a
        "Say nothing":
                v "Maybe this isn't a good time? I'll go ..."
                menu:
                    "{b}\"I need to take a shower anyway.\"{/b}":
                        $ mad += 1
                        call mad_canteen
                        call mad_visitor
                        with dissolve
                        pause 1
                        y "Sorry"
                        pause .5
                        scene black
                        with fade                        
                        jump sc5a
                    "{b}\"Wait! That picture ... do you recognise it?\"{/b}":
                        $ mad -= 1
                        call mad_canteen
                        call mad_visitor
                        with dissolve
                        v "I don't think so ..."
                        y "Mum had the same picture"
                        v "She {w=.5}...{w=.5} {i}had{/i}?"
                        menu:
                            "{b}\"Nevermind, let's take a walk.\"{/b}":
                                scene black
                                with fade
                                jump sc3d
                            "Take a closer look at the picture.":
                                while mad > 1:        
                                     "You can't focus."
                                     menu:
                                        "{i}Get a grip!{/i}":
                                            $ mad -= 1
                                            call mad_canteen
                                            with dissolve                                        
                                        "{i}Don't care ...{/i}":
                                            $ mad +=1
                                            if mad == 6:
                                                call dead
                                                jump start2
                                            call mad_canteen
                                            with dissolve    
                                show picture 
                                with slowdissolve
                                $pictureseen = True                                
                                "It's somewhere in Paris"
                                menu:
                                    "{i}City of the flaneur{/i}":                            
                                        with dissolve
                                        menu:                                
                                            "{i}It was once the height of fashion to be mad{/i}":
                                                $mad += 1
                                                call mad_canteen
                                                call mad_visitor
                                                with dissolve
                                                menu:
                                                    "{i}Voulez-vous coucher avec moi?{/i}":                                                        
                                                        scene black with fade
                                                        jump sc4b
                                            "{b}\"We should go for a walk.\"{/b}":
                                                v "Sure. Whatever you want."
                                                scene black with fade
                                                jump sc3d
                                    "{i}City of light{/i}":
                                        "{i}Lumiere{/i}"
                                        "{i}Luminary{/i}"
                                        "{i}The measure of strength of light is a Lumin{/i}"
                                        $mad +=1 
                                        call mad_canteen
                                        call mad_visitor
                                        with dissolve
                                        y "I need to get some light - some air!"
                                        v "Um, OK, I'll get my coat ..."
                                        y "No! {w=.5} Sorry ..."
                                        "You hurry outside, without looking back."
                                        scene black with fade
                                        jump sc3a                                

label sc2d:
    show bg canteen2 
    with dissolve    
    while mad > 1:     
        "You can't focus."
        menu:
            "{i}Get a grip!{/i}":
                $ mad -= 1
                call mad_canteen
                with dissolve                                        
            "{i}Don't care ...{/i}":
                $ mad +=1
                if mad == 6:
                    call dead
                    jump start2
                call mad_canteen
                with dissolve    
    show picture 
    with slowdissolve
    "It's somewhere in Paris"
    hide picture
    with dissolve
    menu:        
        "{i}City of the flaneur{/i}":                            
            with dissolve
            menu:                                
                "{i}It was once the height of fashion to be mad{/i}":
                    $mad += 1
                    call mad_canteen
                    with dissolve
                    menu:
                        "{i}Voulez-vous coucher avec moi?{/i}":
                            scene black with fade
                            jump sc4a
                "Go for a walk":
                    scene black with fade
                    jump sc3a
        "{i}City of light{/i}":
            "{i}Lumiere{/i}"
            "{i}Luminary{/i}"
            "{i}The measure of strength of light is a Lumin{/i}"
            $mad +=1 
            jump sc2b           
                              
            
### GROUNDS ###

label sc3a:  
    call mad_grounds
    with dissolve          
    $train = True
    $ renpy.music.play("train18.mp3", channel=1, loop=True)        
    show train:
        xpos -350 ypos -1
        pause 3        
        linear 10 xpos 1200        
        pause 5
        repeat            
    pause 1
    "It's cold outside. {w=1} The only movement is from the odd train going past ..."
    "With each passing train, there results a greater silence{w=2}; a more massive stillness ..."
    menu:
        "{i}Satisfying{/i}":
            $ mad -= 1
            jump sc3b
        "{i}Oppressive{/i}":
            $ mad += 1
            jump sc3c

label sc3b:
    call mad_grounds
    with dissolve
    if train == False:
        $train = True
        $ renpy.music.play("train18.mp3", channel=1, loop=True)        
        show train:
            xpos -350 ypos -1
            pause 3        
            linear 10 xpos 1200        
            pause 5
            repeat         
    pause .5
    "As you lose yourself in the flat, horizontal lines of the scenery, you feel yourself relax a little."
    $ mad -= 1
    call mad_grounds
    with dissolve
    "But as soon as you dwell on the moment, an anxiety rises within you:"
    "A dull dread that sooner or later something will disturb this peace."
    jump sc3c
    
label sc3c:
    call mad_grounds
    with dissolve
    pause .5    
    show nurse n3
    with flashfast
    hide nurse n3
    call mad_nurse
    with dissolve
    if train == False:
        $train = True
        $ renpy.music.play("train18.mp3", channel=1, loop=True)        
        show train behind nurse:
            xpos -350 ypos -1
            pause 3        
            linear 10 xpos 1200        
            pause 5
            repeat       
    "Suddenly the woman appears in front of you"
    if visitorbeen == True:
        w "Your visitor's really upset."
        w "I think you should try and talk to him."
    else:
        w "Your visitor's still here ..."
        w "I'll bring him over, OK?"
    menu:
        "{b}\"OK\"{/b}":
            $ mad -= 1
            call hide_nurse
            with dissolve
            jump sc3d
        "{b}\"No!\"{/b}":
            $ mad += 1
            call mad_grounds
            call mad_nurse
            with dissolve
            call hide_nurse
            with dissolve
            "You walk off in search of some peace and quiet"
            $ renpy.music.stop(channel=1)
            scene black with fade
            hide train
            $train = False
            jump sc4a
            
label sc3d:
    call mad_grounds
    call mad_visitor
    with dissolve
    if train == False:
        $train = True
        $ renpy.music.play("train18.mp3", channel=1, loop=True)        
        show train behind visitor:
            xpos -350 ypos -1
            pause 3        
            linear 10 xpos 1200        
            pause 5
            repeat    
    pause .5
    if visitorbeen == True:        
        v "What happened back there?"
    else:
        v "I've finally found you!"
        $visitorbeen = True
    y "Sorry, I'm just not really in the mood for talking"
    "There's a difficult pause"    
    $ mad += 1
    call mad_grounds
    call mad_visitor
    with dissolve
    jump sc3e
            
label sc3e:
    v "No, that's OK."
    pause .5
    v "You look well."
    v "Are you well?"
    "You don't know how you should answer that question"
    menu:
        "{b}\"That's not up to me to say\"{/b}":
                $ mad += 1
                call mad_grounds
                call mad_visitor
                with dissolve
                pause 1
                v "Have you been trainspotting?"
                y "What?"
                v "Watching the trains?"
                menu:
                    "{i}Should I be watching the trains?{/i}":
                        $ mad += 1
                        call mad_grounds
                        call mad_visitor
                        with dissolve
                        "The visitor looks at you expectantly."
                        "You should say something."
                        y "I need a cigarette."
                        "You depart, leaving the confused visitor standing there."
                        scene black with fade
                        $ renpy.music.stop(channel=1)
                        hide train
                        $train = False
                        jump sc6a
                    "{i}Watch. Watching. Train. Training ...{/i}":
                        $ mad += 1
                        call mad_grounds
                        call mad_visitor
                        with dissolve
                        "The Panopticon was a type of trained watch."
                        "It trained the inmates to watch themselves."
                        "Maybe he's making a comment about this place. You should respond."
                        menu: 
                            "{b}\"Yes.\"{/b}":                        
                                v "What?"
                                show visitor n2 
                                with dissolvefast
                                show visitor n3   
                                with dissolvefast                                
                                hide visitor n3
                                call mad_visitor
                                menu:
                                    "Scream":      
                                        call hide_visitor
                                        call dead
                                        $train = False
                                        jump start2                                
        "{i}Didn't he already ask that{/i}":
                $ mad -=1
                call mad_grounds
                call mad_visitor
                with dissolve
                y "It's freezing out here."
                v "Yes it is!"
                v "We should grab a coffee."
                menu:
                    "{b}{i}\"I have measured out my life with coffee spoons\" ...{/i}{/b}":
                        $mad += 1
                        $train = False
                        jump sc3f                
                    "{b}\"OK. Let's go to my room.\"{/b}":
                        $ withvisitor = True
                        scene black with fade
                        hide train
                        $ renpy.music.stop(channel=1)
                        $train = False
                        jump sc4b
                        
label sc3f:
    call mad_grounds
    call mad_visitor
    with dissolve
    v "Oh, that reminds me ..."
    "The visitor reaches into his coat and pulls out a book."
    menu:
        "Look at the book":            
            jump sc3g                                            
        "{b}\"I don't want it\"{/b}":
            $mad += 1
            call mad_grounds
            call mad_visitor
            with dissolve
            v "It's for you. Take it."
            menu:
                "{b}\"I DON'T WANT IT\"{/b}":
                    $mad += 1
                    call mad_grounds
                    call mad_visitor
                    with dissolve
                    v "Please."
                    menu:
                        "{b}\"NOOO!\"{/b}":
                            $mad += 1
                            call mad_grounds
                            call mad_visitor
                            with dissolve
                            call dead
                            $train = False
                            jump start2
                        "{b}\"Alright. Jesus.\"{/b}":
                            $mad -= 1
                            jump sc3g                       
                "Take a look at the book.":
                    $mad -= 1
                    jump sc3g
                
label sc3g:
    call mad_grounds
    call mad_visitor
    with dissolve
    $ bookseen = True
    show book
    with slowdissolve
    "It's an oddly familiar-looking jacket."
    "But it's familiarity is also suspicious."
    y "What is it?"
    v "It's a book about dreams."
    y "Dreams?"
    v "As in, those things that you wish would come true."
    y "Not my dreams."
    v "No, I ... Here, take it."
    "You take the book, grudgingly."
    hide book
    with dissolve
    $mad += 1
    call mad_grounds
    call mad_visitor
    with dissolve    
    "There is an awkward pause that has already lasted just a moment too long to be filled with a late 'Thank You'. So you say nothing."
    "You feel a change of scenery might also change the conversation."
    "Suggest a change ..."
    menu:
        "{b}\"Cigarette?\"{/b}":
            $mad -= 1
            scene black with fade
            hide train
            $ renpy.music.stop(channel=1)
            $train = False
            jump sc6c
        "{b}\"Let's go to my room.\"{/b}":
            $mad += 1
            $withvisitor = True
            hide train
            scene black with fade
            $ renpy.music.stop(channel=1)
            $train = False
            jump sc4b


### ROOM ###

label sc4a:
    call mad_room
    with dissolve     
    "At last, some peace and quiet."
    "But even as you are comforted by this protection, you are repelled by your squalid shelter."
    "This is no place for someone like you."
    menu:
        "Leave your room and take a shower.":
            $mad -=1 
            jump sc5a
        "Blot out those thoughts by taking a nap.":
            $mad += 1
            call mad_room
            with dissolve
            "As you are about to get into bed,"
            jump sc4b

label sc4b:
    call mad_room
    with dissolve
    if withvisitor:
        call mad_visitor    
        with dissolve
    "You hear footsteps approaching."
    menu:
        "Get ready. Tense yourself. ":
            $mad += 1
            call mad_room
            if withvisitor:
                call mad_visitor
            with dissolve
            call mad_rmate 
            with dissolve
            "Your roommate walks in and sits down heavily on your bed."            
            "A surge of emotions - rage and frustration and panic - rise inside you."
            $mad += 1
            call mad_room
            call mad_rmate
            if withvisitor:
                call mad_visitor
            with dissolve
            menu:
                "{b}\"GET OFF MY BED!\"{/b}":
                    $mad += 1
                    call mad_room
                    call mad_rmate
                    if withvisitor:
                        call mad_visitor
                        v "What?"
                    with dissolve
                    "There's no reaction."
                    menu:
                        "{b}\"OFF MY BED! OFF MY BED! OFF!! MY!! BED!!\"{/b}":
                            $mad += 1
                            call mad_room
                            call mad_rmate
                            if withvisitor:
                                call mad_visitor
                                v "Who are you talking to?"
                            with dissolve
                            call dead
                            jump start2
                        "Try a more diplomatic approach":
                            $mad -= 1
                            y "Hey."
                           # move onto the alternative option ...
                "You OK?":
                    $mad -= 1
                    jump sc4c            
        "Welcome the intruder.":            
            $mad -= 1
            y "Hey."  
            call mad_room
            call mad_rmate
            with dissolve
            "Your roommate walks in and sits down heavily on your bed."    
            y "Hey!"
            
label sc4c:            
    call mad_room
    call mad_rmate
    with dissolve
    if withvisitor:
        call mad_visitor
        with dissolve
        v "Who are you talking to?"
    "Your roommate doesn't acknowledge you, but instead sinks further into your bed with deliberate ennui."
    y "You OK?"   
    if withvisitor:       
        v "Yes. Me? {w=.5} Who are you talking to?"
        "You look at the visitor intently."
        y "What?"
        $mad -= 1
        call mad_room
        call mad_rmate
        call mad_visitor
        with dissolve
        v "Who are you ...? {w=1} There are only you and I ... "
        "You let out a slight laugh."
        y "\"Who is the third that walks always beside you?\""
        v "What do you mean?"        
    "Your roommate sighs deeply."
    y "Beatrice?"
    if withvisitor:        
        call mad_visitor
    with dissolve
    "There is no answer. Maybe you should go."
    if withvisitor:
        v "I think we should go - "
        y "Did you ...{w=.5} just read my mind?"
        $mad += 1
        call mad_room
        call mad_rmate
        call mad_visitor
        with dissolve
        v "Come on."
        menu:
            "Go with the visitor.":
                $mad -= 1
                scene black with fade
                jump sc6c                    
            "Try and talk to your roommate some more.":
                $mad += 1
                jump sc4d
    menu:              
        "Go with the visitor." if withvisitor:
            $mad -= 1
            scene black with fade
            jump sc6c 
        "Head outside for a cigarette." if withvisitor == False:
            $mad -= 1
            scene black with fade
            jump sc6a            
        "Try and talk to your roommate some more.":
            $mad += 1
            jump sc4d

label sc4d:
    call mad_room
    call mad_rmate    
    if withvisitor:
        call mad_visitor
    with dissolve
    "You get the feeling your roommate is holding back from telling you something."
    menu:
        "Lean in closer to your roommate." if withvisitor == False:
            $mad += 1
            #call mad_room
            call mad_rmatezoom1
            call mad_roomzoom1
            if withvisitor:
                call mad_visitor
            with dissolve
            play sound "breathing.mp3"  
            "You can hear hard breathing."
            "It makes you uncomfortable."
            menu:
                "Lean in closer still":
                    $mad += 1
                    call mad_rmatezoom2
                    call mad_roomzoom2                   
                    if withvisitor:
                        call mad_visitor
                    with dissolve
                    "You can hear the wheeze and rattle of blocked airways."
                    "It makes you claustrophobic."
                    menu:
                        "Lean closer still":
                            $mad +=1
                            call mad_rmatezoom3
                            call mad_roomzoom3
                            "Your roommate draws you in like a black hole."                                    
                            "It seems as if all available light in the room is fading."            
                            "You get an uneasy feeling as your roommate opens her mouth ..."                                                        
                            "... and lets out a half-gasp - an almost-croak -"        
                            "But says nothing."
                            "Instead, you find yourself holding a torn note."
                            show note with dissolve
                            y "{i}lasciate {w=.5}qui {w=.5}ogni {w=.5}speranza, {w=.5}voi {w=.5}ch'entrate ...{/i}"
                            hide note with dissolve                                                        
                            $noteseen = True
                            "Without pausing to think what it means, you feel the urge to leave immediately."                            
                            jump sc4e
                        "Leave instead":
                            $mad -= 1
                            jump sc4e
                "Leave instead":
                    $mad -=1
                    jump sc4e                    
        "Ask the visitor to leave." if withvisitor:  
            $mad += 1
            call mad_room
            call mad_rmate
            call mad_visitor
            with dissolve
            y "Can you give us a few minutes?"
            "Your visitor looks concerned, but slowly nods and turns to go."
            v "I'll see you soon ...{w=.5} Take care."
            hide visitor
            with dissolve            
            "As soon as the visitor leaves, you address your roommate."
            y "Beatrice ..."
            "There is no response."            
            y "Beatrice!"
            $mad -=1
            call mad_room
            call mad_rmate
            with dissolve
            "Your roommate turns slightly towards you."   
            play sound "breathing.mp3"  
            call mad_rmatezoom1
            call mad_roomzoom1
            with dissolve
            "It seems as if all available light in the room is fading."            
            "You get an uneasy feeling as your roommate prepares to speak ..."
            $mad +=1
            call mad_rmatezoom2
            call mad_roomzoom2
            "... and lets out a half-gasp - an almost-croak -" 
            "But says nothing."            
            "Instead, you find yourself holding a torn note."
            show note with dissolve
            call mad_rmatezoom3
            call mad_roomzoom3
            y "{i}lasciate {w=.5}qui {w=.5}ogni {w=.5}speranza, {w=.5}voi {w=.5}ch'entrate ...{/i}"
            hide note with dissolve            
            "You have no idea what it means but you get a sudden, cold chill."
            $noteseen = True                
            "You leave the room quickly, closing the door firmly behind you."
            $mad -= 1
        "Leave your room and close the door behind you.":
            jump sc4e    

label sc4e:       
    scene black
    show bg hallway at RotoZoom(0,0,0,0.9,0.3,25,opaque=True, xalign=.5,yalign=.5)
    with slowfade
    "You've been here a hundred times... "
    "Except this time something's different."    
    "As you close the door and walk away, there are no screams, no crying ..."
    "Just silence."    
    scene black with slowfade
    if withvisitor:
        jump sc6c
    else:
        jump sc6a            
            
### SHOWER ###

label sc5a:
    call mad_shower
    $ renpy.music.play("shower.mp3", channel=1, loop=True)    
    call mad_poop
    with dissolve
    show water ani
    with dissolve
    "The hot water cloaks you, protectively."
    "As you relax, you begin to zone out."
    menu:
        "{i}Wait a second, is that excrement?{/i}":
            $mad += 1
            call mad_shower        
            call mad_poop
            with dissolve
            menu:
                "{i}Is that {b}my{/b} excrement?{/i}":
                    $mad += 1
                    call mad_shower        
                    call mad_poop
                    with dissolve
                    "You lean down for a closer look ..."
                    menu:
                        "Touch the excrement.":
                            $mad += 1
                            call mad_shower        
                            call mad_poop
                            with dissolve
                            "You extend a toe hesitatingly and give the object a kick."
                            call hide_poop
                            $poop = False
                            "Suddenly it's gone."
                            "You look around you, but there's no sign of it." 
                            "Vanished."                            
                            jump sc5b
                        "Ignore it.":
                             $mad -=1
                             jump sc5b
                "{i}Of course it's not mine.{/i}":
                     call hide_poop
                     $poop = False
                     "You look down again and it's gone."
                     "It must've been a trick of the light."
                     "But still it troubles you."
                     $mad -= 1
                     jump sc5b
        "Just enjoy the shower.":
            "You turn the heat up as far as it will go."
            if bookseen:
                $mad += 1
                "You find yourself dwelling on the book that the visitor gave you ..."
                "{i}Decisions & Revisions{/i}"
                "The title intrigues and frightens you"
                "And the water on your back sounds like thunder."                
            jump sc5b
    
label sc5b:
   call mad_shower
   if poop:
       call mad_poop
   with dissolve
   play sound "knocking.mp3"  
   "Just as you begin to enjoy the moment, there's a banging at the door."
   menu:
        "Answer.":
            $mad -= 1
            call mad_shower        
            if poop:
                call mad_poop
            with dissolve
            "You call out:"
            y "Hello?"
            w "It's your visitor. He's still here."
            y "..."
            if poop:
                "You stare at the excrement in the shower and decide you should get out anyway."
            w "He really wants to talk to you. He's terribly upset."
            menu:
                "{b}\"Tell him I'll be out in a minute.\"{/b}":
                    scene black with fade
                    hide water ani
                    $mad -= 1
                    jump sc3d                
        "Say nothing":
            $mad += 1
            call mad_shower        
            if poop:
                call mad_poop
            with dissolve
            "The woman calls through the door:"
            w "It's your visitor. He's still here."
            y "..."
            $mad += 1
            call mad_shower        
            if poop:
                call mad_poop
            with dissolve
            if poop:
                "You stare at the excrement in the shower and wonder how you got here."
            w "He really wants to talk to you. He's terribly upset."
            "There is an uncomfortable pause."
            "You stay silent, not moving. Not even breathing."
            "Suddenly you hear the lock turning ..."
            "Before you know it, the nurse is in front of you -"
            call dead
            jump start2

            
### SMOKING AREA ###

label sc6a:
    call mad_smoking
    with dissolve
    "The smoking area holds for you a mixture of depression and relief."
    "Depression because this sad, concrete quadrangle represents the pinnacle of your day."
    $mad += 1
    call mad_smoking
    with dissolve
    "Relief, because your cigarette breaks are reliable. They carve up the day in a real way that a clock can't."
    y "Clocks are notoriously unreliable ..."

label sc6b:    
    call mad_nurse
    with dissolve
    w "What do you mean?"    
    y "What? How long have you been listening?"
    w "Why do you say that? Clocks are unreliable."
    "Nothing you can think of would be understood."
    menu:
        "{b}\"It's complicated. Time is realitve.\"{/b}":
            $mad -= 1
            call mad_smoking
            call mad_nurse
            with dissolve
            w "Come on now, not this again."
            menu:
                "{b}\"But you know I'm not lying.\"{/b}":
                    $mad += 1
                    call mad_smoking
                    call mad_nurse
                    with dissolve
                    w "I'm warning you, don't start with this silly talk."
                    menu:
                        "{b}\"Freedom is the freedom to say two plus two equals four ...\"{/b}":
                            call dead
                            jump start2                    
                "{b}\"Nevermind, it's not important.\"{/b}":
                    w "Visitor's still here. You can't put it off forever."
                    call hide_nurse
                    with dissolve
                    jump sc6c
        "{b}\"Nevermind.\"{/b}":
            $mad += 1
            call mad_nurse
            with dissolve
            "The woman frowns at you with undisguised impatience."
            w "Visitor's still here. You can't put it off forever."
            call hide_nurse
            with dissolve
    
label sc6c:    
    call mad_smoking    
    call mad_visitor
    with dissolve
    if withvisitor:
        v "Who were you talking to back there?"
        y "No one."
    elif visitorbeen:        
        v "Kind of lost you back there."
        "You feel weak."
    else:
        v "You're a hard person to find."
        y "I have trouble finding myself."
        v "Ha ha ha!"
        "You look at the visitor with confusion, unsure as to why he is laughing."    
    scene black with fastfade
    call mad_smoking
    call mad_visitor
    with dissolve        
    y "I need a cigarette."      
    "Your visitor laughs a short, nervous laugh. It is slightly threatening."
    y "What does that mean?"
     
    # If been out trainwatching, run the train    
    if visitorbeen:
        $ renpy.music.play("train18.mp3", channel=1, loop=True)
        show train behind visitor:            
            xpos -350 ypos -150
            pause 3
            linear 10 xpos 1200        
            pause 5
            repeat           
        with dissolve
        
    v "Are you ... OK? You look terrible."
    y "No ... I ..."
    "You feel faint. You are desperate for a cigarette to divert your mind."
    "Your world starts swimming ..."   
    scene black with fastfade
    $mad +=1
    call mad_smoking
    call mad_visitor
    with dissolve      
    
    if visitorbeen:
        $ renpy.music.play("train18.mp3", channel=1, loop=True)
        show train behind visitor:            
            xpos -350 ypos -150
            pause 3
            linear 10 xpos 1200        
            pause 5
            repeat           
        with dissolve
    
    # Circle all collected objects together          
    if noteseen:
        show abandonhope: 
            xpos 800 ypos 20
            linear 15 xpos -1000
            repeat
    if pictureseen:
        show picture with dissolve: 
            xalign 0.0 yalign 0.0
            parallel:
                zoom .35
                linear 1.5 zoom .5                    
                linear 1.5 zoom .35                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat  
    else:
        show blob with dissolve: 
            xalign 0.0 yalign 0.0
            parallel:
                zoom .5
                linear 1.5 zoom .8                    
                linear 1.5 zoom .5                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat  
    if bookseen:
        show book with dissolve: 
            xalign 1.0 yalign 1.0
            parallel:
                zoom .35
                linear 1.5 zoom .5                    
                linear 1.5 zoom .35                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat     
    else:
        show blobb with dissolve: 
            xalign 1.0 yalign 1.0
            parallel:
                zoom .5
                linear 1.5 zoom .8                   
                linear 1.5 zoom .5                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat  
    pause 0.3
    if noteseen:
        show note with dissolve: 
            xalign 1.0 yalign 0.0
            parallel:
                zoom .35
                linear 1.5 zoom .5                    
                linear 1.5 zoom .35                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat    
    else:
        show blobbb with dissolve: 
            xalign 1.0 yalign 0.0
            parallel:
                zoom .5
                linear 1.5 zoom .8                   
                linear 1.5 zoom .5                    
                repeat
            parallel:
                alignaround (.5, .5)
                linear 32.0 clockwise circles 12
                repeat    
    pause 7
    "You reach into your pocket expecting to find a lighter."
    "You are surprised instead to pull out a box of matches."
    $mad +=1
        
label sc6d:
    call mad_smoking
    call mad_visitor
    with dissolve
    hide book
    hide picture
    hide train
    hide abandonhope    
    hide note
    hide blob
    hide blobb
    hide blobbb
    with dissolve    
    $ renpy.music.stop(channel=1)
    pause 1
    show hand:
        xpos 0 ypos 200
        linear 4 ypos 0
    pause 4
    call mad_hand 
    with slowdissolve
    pause 1
    "You look down at your shaking hand ..."
    pause 1
    call too_scared
    pause 1    
    "You let out a cross between a laugh and a whimper as you read the box of matches"
    v "What's wrong?"
    y "Like you don't know."
    pause 2
    if pictureseen and bookseen and noteseen:
        jump finalchoice
    else:
        "You want to open the box, but you can't ..."
        "Something just feels ... missing."        
        "Sleep on it. Maybe with a rested mind you'll have more luck ..."
        jump start2
    
label finalchoice:    
    menu:        
        "Open the box":
            jump openthebox
        "Too scared":
            scene black with slowfade
            centered "Oh well. Sleep  on it. Maybe tomorrow you'll have more strength."
            jump start2
            
label openthebox:    
    call hide_visitor
    call hide_hand
    with slowdissolve
    pause 0.5     
    play sound "success.mp3"  
    pause .5
    stop music fadeout 1
    show matchbox:       
        parallel:
            zoom .5
            linear 15 zoom 1.5
        parallel:            
            xpos 200 ypos 150 
            linear 15 xpos -160 ypos -170
    with slowdissolve
    pause 10
    scene black
    with slowfade
    centered "WELCOME {w=.5}BACK {w=1}...{w=4} WE {w=.5}MISSED {w=.5}YOU"              
    $ renpy.full_restart()   
       

###  Calls to MAAAAAAAAAAAAAAAAAAAADNESS ###    
    
# Same routine every time you "die", and same restart point, so this is a separate label used by typing "call dead". 
# Normally calls go off to get a value and "return" it, but in this case, we're just always sending the player back to start2, so no need to return
label dead:
    play sound "dead.mp3" 
    show nurse n4      
    with dissolvefast
    show nurse n5
    with dissolvefast
    show nurse n4
    with dissolve
    hide nurse
    with dissolve    
    scene black
    with fade  
    $ y ("{cps=20}AAAAAAAAAAAAAaaaaarrrrrrrggggghhhhhhhhh ...{/cps}", interact=False)      # show the written scream without forcing a user interaction (click) afterwards to move on
    pause 1.5
    jump start2

# Until you're completely sane (mad = 1) keep showing the menu options that increase and lessen madness respectively 
label too_scared:
    while mad > 1:        
        menu:
            "Focus!":
                $ mad -= 1
                call mad_smoking
                call mad_visitor
                call mad_hand
            "...":
                $ mad +=1
                call mad_smoking
                call mad_visitor
                call mad_hand
    return
               
# mad zooms for the room scene. Since madness is unknown and the zoom is in three stages, we have to call a version of this each step. 
# So each madness function only zooms a maximum way. Of course, the player may click before it fully executes and this will cause it to "jump" but c'est la vie    
# Need a zoom for the room and a zoom for the roommate (roommate enlarges quicker as closer to viewer)
label mad_roomzoom1:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5) 
        # Rotozoom is for rotating and zooming but has the handy built in function of zooming on center, so we just cancel out the zooming (first three zeros). Then "starting zoom", "finish zoom", "time to complete"
        renpy.show ("bg room%d" % mad, [RotoZoom(0,0,0,1,1.4,12,opaque=True), Position(xalign=.5,yalign=.5)])
    return      
label mad_rmatezoom1:
    call cap_mad
    python:                      
        renpy.show ("rmate n%d" % mad, [RotoZoom(0,0,0,1,1.6,12,opaque=False), Position(xalign=.5,yalign=.5)])
    return      
# For the other zooms, we just start off the zoom level where we left previously    
label mad_roomzoom2:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)        
        renpy.show ("bg room%d" % mad, [RotoZoom(0,0,0,1.4,1.9,12,opaque=True), Position(xalign=.5,yalign=.5)])
    return      
label mad_rmatezoom2:
    call cap_mad
    python:                      
        renpy.show ("rmate n%d" % mad, [RotoZoom(0,0,0,1.6,2.3,12,opaque=False), Position(xalign=.5,yalign=.5)])
    return      
label mad_roomzoom3:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)        
        renpy.show ("bg room%d" % mad, [RotoZoom(0,0,0,1.9,2.5,12,opaque=True), Position(xalign=.5,yalign=.5)])
    return      
label mad_rmatezoom3:
    call cap_mad
    python:                      
        renpy.show ("rmate n%d" % mad, [RotoZoom(0,0,0,2.3,3.4,12,opaque=False), Position(xalign=.5,yalign=.55)])
    return      
    
### Other mad functions    
    
# Typical mad function needs to work out:
# -- how mad are you right now? $mad
# -- using the number (1-5) that represents the level of madness, stick this on the end of the asset string 
# -- this gives us the right music to play and the right background and character image(s) to display
# -- before that however, must call the cap_mad function that limits mad to "5" otherwise you get an error (since there is no "bg6.mp3" for example)

label mad_commonroom:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg common%d" % mad)    
    return    

label mad_canteen:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg canteen%d" % mad)    
    return    

label mad_grounds:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg grounds%d" % mad)    
    return    
    
label mad_room:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg room%d" % mad)    
    return  
    
label mad_shower:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg shower%d" % mad)    
    return      
    
label mad_smoking:
    call cap_mad
    python:        
        renpy.music.play ("bg%d.mp3" % mad, fadeout=0.5)
        renpy.show ("bg smoking%d" % mad)    
    return  
    
# The mad character functions are exactly the same but we don't need to make a call to change the background music each time since we never (?) call a character without first calling a background function
    
label mad_nurse:
    call cap_mad
    python:
        renpy.show ("nurse n%d" % mad)
        renpy.transition(dissolve)
    return      

label mad_visitor:
    call cap_mad
    python:
        renpy.show ("visitor n%d" % mad)
        renpy.transition(dissolve)
    return          
 
label mad_rmate:
    call cap_mad
    python:
        renpy.show ("rmate n%d" % mad)
        renpy.transition(dissolve)
    return      

label mad_poop:
    call cap_mad
    python:
        renpy.show ("poop n%d" % mad)
        renpy.transition(dissolve)
    return      

label mad_hand:
    call cap_mad
    python:
        renpy.show ("hand n%d" % mad)
        renpy.transition(dissolve)
    return      
    
# Wrote hide functions for some characters thinking that regular "hide" expression wouldn't work since we never know the exact asset (eg. "nurse n1" or "nurse n2"?) to hide. However, I think that "hide nurse" always works as it doesn't care if it's "nurse n2" or "nurse n4", it just hides anything called "nurse". Oh well, I wrote it now and it works so ...    
    
label hide_nurse:
    call cap_mad
    python:
        renpy.hide ("nurse n%d" % mad)
        renpy.transition(dissolve)
    return      
    
label hide_visitor:
    call cap_mad
    python:
        renpy.hide ("visitor n%d" % mad)
        renpy.transition(dissolve)
    return   

label hide_hand:
    call cap_mad
    python:
        renpy.hide ("hand n%d" % mad)
        renpy.transition(dissolve)
    return  
    
label hide_poop:
    call cap_mad
    python:
        renpy.hide ("poop n%d" % mad)
        renpy.transition(dissolve)
    return   
    
### Simple function for making sure that even when the mad variable goes above 5, we cap it at 5 before using it with any of the above functions    
    
label cap_mad:
    if mad > 5: 
        $ mad = 5
    elif mad < 1:
        $ mad = 1
    return                
 
